<?php
/**
 * Admin Login - Secure Authentication
 */

require_once '../includes/config.php';
require_once '../includes/admin-auth.php';

session_start();

$error = '';
$auth = new AdminAuth($pdo);

// If already logged in, redirect
if ($auth->isLoggedIn()) {
    header('Location: orders.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? 'admin'); // Default username
    $password = $_POST['password'] ?? '';
    
    if (empty($password)) {
        $error = 'Please enter your password';
    } else {
        $result = $auth->login($username, $password);
        
        if ($result['success']) {
            // Set session variables
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user_id'] = $result['user_id'];
            $_SESSION['admin_username'] = $result['username'];
            $_SESSION['admin_login_time'] = time();
            
            header('Location: orders.php');
            exit();
        } else {
            $error = $result['error'] ?? 'Invalid credentials';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Binance P2P</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 40px;
            max-width: 400px;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <h2 class="text-center mb-4">
            <i class="bi bi-currency-bitcoin"></i> Binance P2P
        </h2>
        <h5 class="text-center text-muted mb-4">Admin Login</h5>
        
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Username</label>
                <input type="text" name="username" class="form-control" value="admin" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required autofocus>
            </div>
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-box-arrow-in-right"></i> Login
            </button>
        </form>
        
        <div class="mt-3 text-center text-muted">
            <small>Default username: admin | Default password: admin123</small>
            <br><small class="text-danger">⚠️ Change default password after first login!</small>
        </div>
    </div>
</body>
</html>

